<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version3;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsBuilderInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Sso\WebserviceBundle\ErrorHandler\Manager as ErrorManager;

/**
 * Class ErrorsBuilder
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version3
 */
final class ErrorsBuilder implements ErrorsBuilderInterface
{

    /**
     * @var \Sso\WebserviceBundle\ErrorHandler\ErrorStorage\Errors
     */
    private $errorsStorage;

    /**
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * @var ErrorManager
     */
    private $errorManager;

    /**
     * @var array
     */
    private $errorsMapping = [
        'getCode' => 'setCode',
        'getStatus' => 'setStatus',
        'getCount' => 'setErrorCount',
        'getController' => 'setController',
        'getAction' => 'setAction'
    ];

    /**
     * @var array
     */
    private $errorMapping = [
        'getCode' => 'setCode',
        'getStatus' => 'setStatus',
        'getErrorCode' => 'setErrorCode',
        'getErrorRef' => 'setErrorReference',
        'getShortMessage' => 'setShortMessage',
        'getLongMessage' => 'setLongMessage',
        'getType' => 'setType'
    ];

    /**
     * ErrorsBuilder constructor.
     * @param ErrorManager $errorManager
     */
    public function __construct(ErrorManager $errorManager)
    {
        $this->errorManager = $errorManager;
        $this->errorsStorage = $errorManager->errorStorage()->getStoredErrors();
        $this->errors = new Errors();

        foreach ($this->errorsMapping as $getter => $setter) {
            $this->errors->$setter($this->errorManager->errorStorage()->getStoredErrors()->$getter());
        }
    }


    /**
     * @return ErrorsInterface
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @return ErrorsInterface
     */
    public function buildErrors()
    {
        foreach ($this->errorsStorage->getErrors() as $error){
            $errorMapped = $this->mapErrorType($error);
            $this->errors->addError($errorMapped);
        }

        return $this->getErrors();
    }

    /**
     * @param $error
     * @return Error
     */
    private function mapErrorType($error)
    {
        $errorObject = new Error();
        foreach ($this->errorMapping as $getter => $setter) {
            $errorObject->$setter($error->$getter());
        }
        return $errorObject;
    }
}