<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version3\Response;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\ResponseBuilderInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\ResponseInterface;
use Sso\WebserviceBundle\ErrorHandler\Manager as ErrorManager;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("Error")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version3
 */
class ResponseBuilder implements ResponseBuilderInterface
{
    /**
     * @var ErrorManager
     */
    private $errorManager;

    /**
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * ResponseBuilder constructor.
     * @param ErrorsInterface $errors
     */
    public function __construct(ErrorsInterface $errors, ErrorManager $errorManager)
    {
        $this->errors = $errors;
        $this->errorManager = $errorManager;
    }

    /**
     * @return ResponseInterface
     */
    public function buildErrorResponse(){
        $responseObject = new Response();
        $responseObject->setScriptTimeSec($this->errorManager->getScriptSeconds());
        $responseObject->setCode($this->errors->getCode());
        $responseObject->setStatus($this->errors->getStatus());
        $responseObject->setController($this->errors->getController());
        $responseObject->setAction($this->errors->getAction());
        $responseObject->setErrorCount($this->errors->getErrorCount());
        $responseObject->setErrors($this->errors);

        return $responseObject;
    }
}
