<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Event;

use Sso\WebserviceBundle\Entity\Webservice\Type\User;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class AbstractUserAuthorizationEvent
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Event
 */
class UserAuthorizationEvent extends Event
{
    const PRE_UPDATE = 'ws.user_update.pre_update';
    const PRE_DELETE = 'ws.user_delete.pre_delete';
    const PRE_SHOW = 'ws.user_show.pre_show';

    /**
     * @var User
     */
    private $user;

    /**
     * @var bool
     */
    private $isAuthorized = true;

    /**
     * AbstractUserAuthorizationEvent constructor.
     * @param User $user
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * @return User
     */
    public function getUser(): User
    {
        return $this->user;
    }

    /**
     * @return bool
     */
    public function isAuthorized(): bool
    {
        return $this->isAuthorized;
    }

    public function unAuthorize(): void
    {
        $this->isAuthorized = false;
    }
}
