<?php

/**
 * Steps Box
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\EventListener;

use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class RequestHeaderListener implements EventSubscriberInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * RequestHeaderListener constructor.
     * @param LoggerInterface $logger
     */
    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return array(
            KernelEvents::REQUEST => array('addHeaders', 1024)
        );
    }

    /**
     * Add missing headers to request - for WS-user
     *
     * @param GetResponseEvent $event
     */
    public function addHeaders(GetResponseEvent $event)
    {
        $request = $event->getRequest();
        if (!$request->headers->has('Accept') || !strlen($request->headers->get('Accept')) || 'none' == $request->headers->get('Accept')) {
            $request->headers->set('Accept', '*/*');
            $this->logger->info('Added missing header "Accept: */*" to request');
        }
    }
}
