<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model;

use Sso\WebserviceBundle\Model\Request\Factory as RequestFactory;
use Sso\WebserviceBundle\Model\Response\Factory as ResponseFactory;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Response\Builder as XmlResponse;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Model
 */
final class Factory
{

    /**
     * List of factory objects
     * @var array
     */
    protected $factories = array();

    /**
     * Api Manager
     * @var ApiManager
     */
    private $apiM;

    /**
     * Factory constructor.
     * @param ApiManager $apiM
     * @param string $apiVersion
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @deprecated since api-version-2
     * @return RequestFactory
     */
    public function request()
    {
        if (!isset($this->factories['request'])) {
            $this->factories['request'] = new RequestFactory($this->apiM);
        }

        return $this->factories['request'];
    }

    /**
     * @deprecated since api-version-2
     * @param XmlResponse $xmlResponse Xml response document
     * @return ResponseFactory
     */
    public function response(XmlResponse $xmlResponse)
    {
        if (!isset($this->factories['response'])) {
            $this->factories['response'] = new ResponseFactory($xmlResponse);
        }

        return $this->factories['response'];
    }
}
