<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\Application;

/**
 * Class Add
 * @package Sso\WebserviceBundle\Model\Request\Application
 */
class Add extends Base
{
    /**
     * Init application model
     * @param \SimpleXMLElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Value->ApplicationType->children()));
    }

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    protected function _factoryApplication($xml)
    {
        // Validate for add
        return $this->typeF->application($xml, array('Application_Add'));
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Value required="true">'
                . '<ApplicationType required="true">'
                . '<Name required="true"></Name>'
                . '<Description></Description>'
                . '</ApplicationType>'
                . '</Value>';
    }
}
