<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\Application;

use Sso\WebserviceBundle\Model\Request\Base as RequestBase;
use Sso\WebserviceBundle\Entity\Webservice\Type\Application as ApplicationModel;

/**
 * Class Base
 * @package Sso\WebserviceBundle\Model\Request\Application
 */
abstract class Base extends RequestBase
{
    /**
     * @var ApplicationModel
     */
    protected $applicationModel;

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        return !$this->applicationModel ? $errors : array_merge($errors, $this->applicationModel->errors()->getErrors());
    }

    /**
     * @param ApplicationModel $applicationModel
     */
    public function setApplicationModel(ApplicationModel $applicationModel)
    {
        $this->applicationModel = $applicationModel;
    }

    /**
     * @return ApplicationModel
     */
    public function getApplicationModel()
    {
        return $this->applicationModel;
    }
}
