<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\ApplicationRole;

/**
 * Role request
 */
class Add extends Base
{
    /**
     * Init role model
     * @param \SimpleXMLElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Key->ApplicationType->children()));
        $this->setRoleModel($this->_factoryRole($simpleXML->Value->RoleType->children()));
    }

    /**
     * Build role object
     * 
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Role
     */
    protected function _factoryRole($xml)
    {
        // Validate for add
        return $this->typeF->role($xml, array('ApplicationRole_Add'));
    }

    /**
     * Build application object
     * 
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    protected function _factoryApplication($xml)
    {
        // Validate for adding new role
        return $this->typeF->application($xml, array('ApplicationRole_Add'));
    }

    /**
     * Returns a list of allowed field names in xml
     * 
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
                . '<ApplicationType required="true">'
                . '<Name required="true"></Name>'
                . '</ApplicationType>'
                . '</Key>'
                . '<Value required="true">'
                . '<RoleType required="true">'
                . '<Name required="true"></Name>'
                . '<Description></Description>'
                . '</RoleType>'
                . '</Value>';
    }
}
