<?php

/**
 * User request  
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\User;

use Sso\WebserviceBundle\Model\Request\Base as RequestBase;
use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;

/**
 * User request base class
 */
abstract class Base extends RequestBase
{

    /**
     * @var UserModel
     */
    protected $userModel;

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->userModel) {
            $errors = array_merge($errors, $this->userModel->errors()->getErrors());
        }
        return $errors;
    }

    /**
     * Set user model
     * @param UserModel $userModel
     */
    public function setUserModel(UserModel $userModel)
    {
        $this->userModel = $userModel;
    }

    /**
     * Get user model
     * @return UserModel
     */
    public function getUserModel()
    {
        return $this->userModel;
    }
}
