<?php

/**
 * User application request
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplication;

use Sso\WebserviceBundle\Entity\Webservice\Type\Application as ApplicationModel;

/**
 * Class Add
 * @package Sso\WebserviceBundle\Model\Request\UserApplication
 */
class Add extends Base
{
    const USER_APP_ADD = "UserApplication_Add";
    /**
     * @var ApplicationModel
     */
    protected $applicationModel;

    /**
     * Init models
     * @param \DOMElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Key->UserType->children()));
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Value->ApplicationType->children()));
        $this->setUserApplicationModel($this->_factoryUserApplication($simpleXML->Value->ApplicationType->children()));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUser($xml)
    {
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, static::USER_APP_ADD);

        return $this->typeF->user($xml, $validationGroups);
    }

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return ApplicationModel
     */
    protected function _factoryApplication($xml)
    {
        return $this->typeF->application($xml, [static::USER_APP_ADD]);
    }

    /**
     * @param ApplicationModel $applicationModel
     */
    public function setApplicationModel(ApplicationModel $applicationModel)
    {
        $this->applicationModel = $applicationModel;
    }

    /**
     * @return ApplicationModel
     */
    public function getApplicationModel()
    {
        return $this->applicationModel;
    }

    /**
     * Build user application object
     * @param \DOMElement $xml
     * @return UserApplicationModel
     */
    protected function _factoryUserApplication($xml)
    {
        return $this->typeF->userApplication($xml, [static::USER_APP_ADD]);
    }

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->applicationModel) {
            $errors = array_merge($errors, $this->applicationModel->errors()->getErrors());
        }

        return $errors;
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
        .'<UserType required="true">'
        .'<Identifier />'
        .'<Guid />'
        .'<Username />'
        .'<Email />'
        .'</UserType>'
        .'</Key>'
        .'<Value required="true">'
        .'<ApplicationType required="true">'
        .'<Name required="true"></Name>'
        .'<Active required="true"></Active>'
        .'</ApplicationType>'
        .'</Value>';
    }
}
