<?php

/**
 * User request
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplication;

use Sso\WebserviceBundle\Model\Request\User\Base as RequestBase;
use Sso\WebserviceBundle\Entity\Webservice\Type\UserApplication as UserApplicationModel;

/**
 * User request base class
 */
abstract class Base extends RequestBase
{
    /**
     * @var UserApplicationModel
     */
    protected $userApplicationModel;

    /**
     * @param UserApplicationModel $userApplicationModel
     */
    public function setUserApplicationModel(UserApplicationModel $userApplicationModel)
    {
        $this->userApplicationModel = $userApplicationModel;
    }

    /**
     * @return UserApplicationModel
     */
    public function getUserApplicationModel()
    {
        return $this->userApplicationModel;
    }

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->userApplicationModel) {
            $errors = array_merge($errors, $this->userApplicationModel->errors()->getErrors());
        }

        return $errors;
    }
}
