<?php

/**
 * User application request  
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplication;

use Sso\WebserviceBundle\Entity\Webservice\Type\Application as ApplicationModel;

/**
 * User request delete application from user
 */
class Delete extends Base
{

    /**
     * @var ApplicationModel
     */
    protected $applicationModel;

    /**
     * Init models
     * @param \DOMElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Key->UserType->children()));
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Key->ApplicationType->children()));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUser($xml)
    {
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, 'UserApplication_Delete');
        return $this->typeF->user($xml, $validationGroups);
    }

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return ApplicationModel
     */
    protected function _factoryApplication($xml)
    {
        return $this->typeF->application($xml, array('UserApplication_Delete'));
    }

    /**
     * @param ApplicationModel $applicationModel
     */
    public function setApplicationModel(ApplicationModel $applicationModel)
    {
        $this->applicationModel = $applicationModel;
    }

    /**
     * 
     * @return ApplicationModel
     */
    public function getApplicationModel()
    {
        return $this->applicationModel;
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
                . '<UserType required="true">'
                . '<Identifier />'
                . '<Guid />'
                . '<Username />'
                . '<Email />'
                . '</UserType>'
                . '<ApplicationType required="true">'
                . '<Name required="true"></Name>'
                . '</ApplicationType>'
                . '</Key>';
    }
}
