<?php

/**
 * Attribute request for attributes
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplicationAttribute;

use Sso\WebserviceBundle\Model\Request\User\Base as RequestBase;
use Sso\WebserviceBundle\Entity\Webservice\Type\Application as ApplicationModel;
use Sso\WebserviceBundle\Entity\Webservice\Type\UserApplication as UserApplicationModel;

/**
 * Attribute request base class
 */
abstract class Base extends RequestBase
{

    /**
     * @var ApplicationModel
     */
    protected $applicationModel;

    /**
     * @var UserApplicationModel
     */
    protected $userApplicationModel;

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->applicationModel) {
            $errors = array_merge($errors, $this->applicationModel->errors()->getErrors());
        }

        return $errors;
    }

    /**
     * @param ApplicationModel $applicationModel
     */
    public function setApplicationModel(ApplicationModel $applicationModel)
    {
        $this->applicationModel = $applicationModel;
    }

    /**
     * @return ApplicationModel
     */
    public function getApplicationModel()
    {
        return $this->applicationModel;
    }

    /**
     * @param UserApplicationModel $userApplicationModel
     */
    public function setUserApplicationModel(UserApplicationModel $userApplicationModel)
    {
        $this->userApplicationModel = $userApplicationModel;
    }

    /**
     * @return UserApplicationModel
     */
    public function getUserApplicationModel()
    {
        return $this->userApplicationModel;
    }
}
