<?php

/**
 * Attribute request for adding new application
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplicationAttribute;

use Sso\WebserviceBundle\Entity\Webservice\Type\Attribute as AttributeModel;

/**
 * Attribute request
 */
class Delete extends Base
{
    /**
     * @var AttributeModel
     */
    protected $applicationAttribute;

    /**
     * Init attribute model
     * @param \SimpleXMLElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Key->UserType->children()));
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Key->ApplicationType->children()));
        $this->setApplicationAttributeModel($this->_factoryApplicationAttribute($simpleXML->Key->AttributeType->children()));
    }

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->applicationAttribute) {
            $errors = array_merge($errors, $this->applicationAttribute->errors()->getErrors());
        }

        return $errors;
    }

    /**
     * @param AttributeModel $applicationAttribute
     */
    public function setApplicationAttributeModel(AttributeModel $applicationAttribute)
    {
        $this->applicationAttribute = $applicationAttribute;
    }

    /**
     * @return ApplicationModel
     */
    public function getApplicationAttributeModel()
    {
        return $this->applicationAttribute;
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUser($xml)
    {
        // Validate for application attribute delete
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, 'UserApplicationAttribute_Delete');

        return $this->typeF->user($xml, $validationGroups);
    }

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    protected function _factoryApplication($xml)
    {
        // Validate for adding new attribute
        return $this->typeF->application($xml, array('UserApplicationAttribute_Delete'));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Attribute
     */
    protected function _factoryApplicationAttribute($xml)
    {
        // Validate for application attribute show
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, 'UserApplicationAttribute_Delete');

        return $this->typeF->attribute($xml, $validationGroups);
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
        .'<UserType required="true">'
        .'<Guid />'
        .'<Email />'
        .'<Username />'
        .'<Identifier />'
        .'</UserType>'
        .'<ApplicationType required="true">'
        .'<Name required="true"></Name>'
        .'</ApplicationType>'
        .'<AttributeType required="true">'
        .'<Name required="true"></Name>'
        .'</AttributeType>'
        .'</Key>';
    }
}
