<?php

/**
 * User application request
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplicationRole;

use Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * User request delete application role from user
 */
class Delete extends Base
{

    /**
     * @var RoleModel
     */
    protected $roleModel;

    /**
     * Init models
     * @param \DOMElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Key->UserType->children()));
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Key->ApplicationType->children()));
        $this->setRoleModel($this->_factoryRole($simpleXML->Key->RoleType->children()));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return Type\User
     */
    protected function _factoryUser($xml)
    {
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, 'UserApplicationRole_Delete');

        return $this->typeF->user($xml, $validationGroups);
    }

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return Type\Application
     */
    protected function _factoryApplication($xml)
    {
        return $this->typeF->application($xml, array('UserApplicationRole_Delete'));
    }

    /**
     * Build role object
     * @param \DOMElement $xml
     * @return Type\Role
     */
    protected function _factoryRole($xml)
    {
        // Validate for add
        return $this->typeF->role($xml, array('UserApplicationRole_Delete'));
    }

    /**
     * @param Type\Role $roleModel
     */
    public function setRoleModel(Type\Role $roleModel)
    {
        $this->roleModel = $roleModel;
    }

    /**
     * @return Type\Role
     */
    public function getRoleModel()
    {
        return $this->roleModel;
    }

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->roleModel) {
            $errors = array_merge($errors, $this->roleModel->errors()->getErrors());
        }

        return $errors;
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
        .'<UserType required="true">'
        .'<Identifier />'
        .'<Guid />'
        .'<Username />'
        .'<Email />'
        .'</UserType>'
        .'<ApplicationType required="true">'
        .'<Name required="true"></Name>'
        .'</ApplicationType>'
        .'<RoleType required="true">'
        .'<Name required="true"></Name>'
        .'</RoleType>'
        .'</Key>';
    }
}
