<?php

/**
 * User application role request factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplicationRole;

use Sso\WebserviceBundle\Model\Type\Factory as TypeFactory;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Exception\Type\Base as BaseException;
use Sso\WebserviceBundle\Model\Request\UserApplicationRole;

/**
 * User application role request factory
 */
class Factory
{

    /**
     * Factory object
     * @var TypeFactory
     */
    protected $typeF;

    /**
     * Api Manager
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->typeF = new TypeFactory($this->apiM);
    }

    /**
     * Add user application role factory
     * @param \DOMElement $simpleXML
     * @return UserApplicationRole\Add
     */
    public function add($simpleXML)
    {
        $model = new UserApplicationRole\Add($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Show user application role factory
     * @param \DOMElement $simpleXML
     * @return UserApplicationRole\Show
     */
    public function show($simpleXML)
    {
        $model = new UserApplicationRole\Show($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Delete user application role factory
     * @param \DOMElement $simpleXML
     * @return UserApplicationRole\Delete
     */
    public function delete($simpleXML)
    {
        $model = new UserApplicationRole\Delete($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }
}
