<?php

/**
 * Application response for showing application role
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\ApplicationRole;

/**
 * Application role response
 */
class Show extends Base
{

    /**
     * Returns response status
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return (boolean)$this->role;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->role ? false : 'Application role not found';
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        if (!$this->role) {
            parent::buildResponseBody($xmlContainer);

            return;
        }
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('ApplicationRoleType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Name', $this->role->getName()));
        $typeElement->appendChild($document->createTextElement('Description', $this->role->getDescription()));
    }
}
