<?php

/**
 * User response for adding new user
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\User;

/**
 * User response
 */
class Add extends Base
{
    /**
     * Returns response status
     * @return bool
     */
    protected function getResponseStatus()
    {
        return (boolean)$this->user;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->user ? 'User added' : 'User not found';
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        if ($this->user) {
            $this->addUserType($xmlContainer);
        }
    }
}
