<?php

/**
 * User response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\User;

use Sso\WebserviceBundle\Model\Response\Base as ResponseBase;
use Sso\WebserviceBundle\Model\Request;

/**
 * User response base class
 */
abstract class Base extends ResponseBase
{

    /**
     * User model
     * @var \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected $user;

    /**
     * Get response for application-show
     * @param Request\Base $requestModel
     */
    public function createResponse(Request\Base $requestModel)
    {
        $this->user = $requestModel->getUserModel();
        $this->buildResponse($requestModel);
    }

    /**
     * Add user to xml response
     * @param \DOMElement $xmlContainer
     */
    protected function addUserType(\DOMElement $xmlContainer)
    {
        if (!$this->user) {
            return;
        }
        $document = $this->xmlResponse->document();
        $user = $document->createElement('UserType');
        $xmlContainer->appendChild($user);

        $user->appendChild($document->createTextElement('Guid', $this->user->getGuid()));
        $user->appendChild($document->createTextElement('Username', $this->user->getUsername()));
        $user->appendChild($document->createTextElement('Email', $this->user->getEmail()));
        $user->appendChild($document->createTextElement('Firstname', $this->user->getFirstname()));
        $user->appendChild($document->createTextElement('Lastname', $this->user->getLastname()));
        $user->appendChild($document->createBoolElement('Active', $this->user->getActive()));

        $user->appendChild($document->createTextElement('AuthId', $this->user->getAuthId()));
        $user->appendChild($document->createTextElement('LdapSearchAttributes',
            $this->user->getLdapSearchAttributes()));
        $user->appendChild($document->createTextElement('LdapSearchValue', $this->user->getLdapSearchValue()));

        // Append activation token, if user is not active
        if (!$this->user->getActive() && $this->user->getActivateToken() && $this->user->getActivateTokenExpire()) {
            $user->appendChild($document->createTextElement('ActivateToken', $this->user->getActivateToken()));
            $user->appendChild($document->createTextElement('ActivateTokenExpire',
                $this->user->getActivateTokenExpire()->format('Y-m-d H:i:s')));
        }
    }
}
