<?php

/**
 * User response for adding new user 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplication;

use Sso\WebserviceBundle\Model\Response\BaseFactory;
use Sso\WebserviceBundle\Model\Response\UserApplication as Response;
use Sso\WebserviceBundle\Model\Request\UserApplication as Request;

/**
 * Factory for user application
 */
class Factory extends BaseFactory
{

    /**
     * @param Request\Show $requestModel
     * @param array $appReadAccess
     */
    public function show(Request\Show $requestModel, $appReadAccess = [])
    {
        $model = new Response\Show($this->xmlResponse);
        $model->createResponse($requestModel, $appReadAccess);
    }

    /**
     * @param Request\Show $requestModel
     * @param array $appReadAccess
     */
    public function showDetails(Request\ShowDetails $requestModel, $appReadAccess = [])
    {
        $model = new Response\ShowDetails($this->xmlResponse);
        $model->createResponse($requestModel, $appReadAccess);
    }

    /**
     * @param Request\Add $requestModel
     */
    public function add(Request\Add $requestModel)
    {
        $model = new Response\Add($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\Delete $requestModel
     */
    public function delete(Request\Delete $requestModel)
    {
        $model = new Response\Delete($this->xmlResponse);
        $model->createResponse($requestModel);
    }
}
