<?php

/**
 * User response for adding application to user
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplication;

use Sso\WebserviceBundle\Model\Request;

/**
 * User application show response
 */
class Show extends Base
{
    /**
     * User model
     * @var \Sso\WebserviceBundle\Entity\Webservice\Type\UserApplication
     */
    protected $userApplication;

    /**
     * @var array
     */
    protected $appReadAccess;

    /**
     * @param Request\Base $requestModel
     * @param array $appReadAccess
     */
    public function createResponse(Request\Base $requestModel, $appReadAccess = [])
    {
        $this->appReadAccess = $appReadAccess;
        $this->userApplication = $requestModel->getUserApplicationModel();
        parent::createResponse($requestModel);
    }


    /**
     * Returns response status
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return (boolean)$this->user;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->user ? false : 'User not found';
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        if ($this->user) {
            $this->_addUserResponse($xmlContainer, $this->user);
            $applicationActive = $this->userApplication ? (bool)$this->userApplication->getActive() : null;
            foreach ($this->user->getUserApplications() as $userApplication) {
                //check read on application
                if(!in_array($userApplication->getName(), $this->appReadAccess)){
                    continue;
                }
                // Filter applications, if request contained active-flag
                if (true === $applicationActive && !$userApplication->getActive() ||
                    false === $applicationActive && $userApplication->getActive()
                ) {
                    continue;
                }
                $this->_addApplicationResponse($xmlContainer, $userApplication);
            }
        }
    }
}
