<?php

/**
 * User response for showing user data
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplicationAttribute;

use Sso\WebserviceBundle\Model\Request;

/**
 * User response
 */
class Show extends Base
{

    /**
     * Returns response status
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->user && $this->userApplication;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        $messages = array();
        if (!$this->user) {
            $messages[] = 'User not found';
        }
        if (!$this->userApplication) {
            $messages[] = 'Application not found';
        }

        return 0 == count($messages) ? false : implode(', ', $messages);
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        if ($this->user && $this->userApplication) {
            $this->_addUserResponse($xmlContainer, $this->user);
            $this->_addApplicationResponse($xmlContainer, $this->userApplication);
            foreach ($this->userApplication->getAttributes() as $userApplicationAttribute) {
                $this->_addAttributeResponse($xmlContainer, $userApplicationAttribute);
            }
        }
    }
}
