<?php

/**
 * User application attribute response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplicationRole;

use Sso\WebserviceBundle\Model\Response\UserApplication\Base as ResponseBase;
use Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * User application attribute response base class
 */
abstract class Base extends ResponseBase
{
    
    /**
     * Add list of roles to response
     * @param \DOMElement $xmlContainer
     * @param Type\UserApplicationRole $userApplicationRole
     */
    protected function _addRoleResponse(\DOMElement $xmlContainer, Type\UserApplicationRole $userApplicationRole)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('RoleType');
        $xmlContainer->appendChild($typeElement);
        $typeElement->appendChild($document->createTextElement('Name', $userApplicationRole->getName()));
        $typeElement->appendChild($document->createBoolElement('Active', $userApplicationRole->getActive()));
    }
}
