<?php

/**
 * User serach response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserSearch;

use Sso\WebserviceBundle\Model\Response\Base as ResponseBase;
use Sso\WebserviceBundle\Model\Request;

/**
 * User serach response base class
 */
abstract class Base extends ResponseBase
{

    /**
     * Search result
     * @var array
     */
    protected $resultRows;

    /**
     * Get response for application-show
     * @param Request\Base $requestModel
     */
    public function createResponse(Request\Base $requestModel)
    {
        $this->resultRows = $requestModel->getSearchResult();
        $this->buildResponse($requestModel);
    }

    /**
     * Returns response status
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return null !== $this->resultRows ? true : false;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        return null !== $this->resultRows ? false : 'Error while searching';
    }
}
