<?php

/**
 * User search response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserSearch;


class FindByApplicationRole extends Base
{

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        if ($this->resultRows) {
            $document = $this->xmlResponse->document();
            foreach ($this->resultRows as $row) {
                $typeElement = $document->createElement('UserType');
                $typeElement->appendChild($document->createTextElement('Guid', $row['Guid']));
                $xmlContainer->appendChild($typeElement);
            }
        }
    }
}