<?php

/**
 * User service request factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserService;

use Sso\WebserviceBundle\Model\Response\BaseFactory;
use Sso\WebserviceBundle\Model\Response\UserService as Response;
use Sso\WebserviceBundle\Model\Request\UserService as Request;

class Factory extends BaseFactory
{

    /**
     * @param Request\PasswordRequest $requestModel
     */
    public function passwordRequest(Request\PasswordRequest $requestModel)
    {
        $model = new Response\PasswordRequest($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\PasswordConfirm $requestModel
     */
    public function passwordConfirm(Request\PasswordConfirm $requestModel)
    {
        $model = new Response\PasswordConfirm($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\ActivateRequest $requestModel
     */
    public function activateRequest(Request\ActivateRequest $requestModel)
    {
        $model = new Response\ActivateRequest($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\ActivateConfirm $requestModel
     */
    public function activateConfirm(Request\ActivateConfirm $requestModel)
    {
        $model = new Response\ActivateConfirm($this->xmlResponse);
        $model->createResponse($requestModel);
    }
}
