<?php
namespace Sso\WebserviceBundle\Security\Api\Firewall;

use Sso\WebserviceBundle\Security\Api\Manager as ApiManager;

/**
 * Class Factory
 * @package Sso\WebserviceBundle\Security\Api\Firewall
 */
class Factory
{
    /**
     * @var array
     */
    private $setter;

    /**
     * @var ApiManager
     */
    private $apiM;


    /**
     * Factory constructor.
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
       $this->apiM = $apiM;
    }

    /**
     * @return Level\One
     */
    public function levelOne()
    {
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new Level\One($this->apiM));
    }

    /**
     * @return Level\Two
     */
    public function levelTwo()
    {
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new Level\Two($this->apiM));
    }

    /**
     * @return Level\Three
     */
    public function levelThree()
    {
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new Level\Three($this->apiM, $this->apiM->processDetails()));
    }

    /**
     * @return Level\Four
     */
    public function levelFour()
    {
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new Level\Four($this->apiM, $this->apiM->featureToggle()));
    }
}
