<?php

/**
 * Class WsFirewallToken
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Authentication\Token;

use Symfony\Component\Security\Core\Authentication\Token\AbstractToken;

/**
 * Class WsFirewallToken
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Security\Authentication\Token
 */
class WsFirewallToken extends AbstractToken implements WsFirewallTokenInterface
{

    /**
     * @var string
     */
    public $userIdentifier;

    /**
     * @var string
     */
    public $serviceToken;

    /**
     * @var string
     */
    public $userName;

    /**
     * @var string
     */
    public $controller;

    /**
     * @var string
     */
    public $action;

    /**
     * @var string
     */
    public $remoteIp;

    /**
     * @var array
     */
    public $userWsRoles;

    /**
     * @var array
     */
    public $userWsServiceTokens;

    /**
     * @var bool
     */
    public $accessRestricted;

    /**
     * @var string|null
     */
    public $applicationUsername;

    /**
     * @var string|null
     */
    public $applicationUserIdentifier;

    /**
     *
     * @param array $roles
     */
    public function __construct(array $roles = array())
    {
        parent::__construct($roles);

        // If the user has roles, consider it authenticated
        $this->setAuthenticated(count($roles) > 0);
    }

    /**
     * @return string
     */
    public function getCredentials()
    {
        return '';
    }

    /**
     * @return array
     */
    public function getUserWsRolesRead(): array
    {
        return isset($this->userWsRoles['read']) ? $this->userWsRoles['read'] : [];
    }

    /**
     * @return array
     */
    public function getUserWsRolesWrite(): array
    {
        return isset($this->userWsRoles['write']) ? $this->userWsRoles['write'] : [];
    }

    /**
     * @return array
     */
    public function getUserWsServiceTokens()
    {
        return $this->userWsServiceTokens;
    }
}
