<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services;

/**
 * Interface ApiVersionInflectorInterface
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services
 */
interface ApiVersionInflectorInterface
{
    /**
     * Returns class name for versioned class
     *
     * @param string $namespace
     * @param string $className
     * @return string
     */
    public function inflect($namespace, $className);

    /**
     * Returns service name for versioned service
     *
     * @param string $prefix
     * @param string $serviceName
     * @return string
     */
    public function inflectService($prefix, $serviceName);
}
