<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All;

use Sso\WebserviceBundle\Services\HandlerFactoryInterface;
use Sso\WebserviceBundle\Services\HandlerInterface;
use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\ApiVersionInflectorInterface;

/**
 * Class Factory
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\Application\All
 */
class Factory implements HandlerFactoryInterface
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * @var ApiVersionInflectorInterface
     */
    private $apiVersionInflector;

    /**
     * Factory constructor.
     * @param ApiManagerInterface $apiM
     * @param ApiVersionInflectorInterface $apiVersionInflector
     */
    public function __construct(ApiManagerInterface $apiM, ApiVersionInflectorInterface $apiVersionInflector)
    {
        $this->apiM = $apiM;
        $this->apiVersionInflector = $apiVersionInflector;
    }

    /**
     * @return HandlerInterface
     */
    public function handler()
    {
        return $this->apiM->container->get('sso_webservice.services_application_all.handler');
    }
}
