<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class All
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\Application\All\Response\Version3
 */
class All
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("integer")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("Offset")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $offset;

    /**
     * @Serializer\SerializedName("Limit")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $limit;

    /**
     * @Serializer\SerializedName("OrderBy")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderBy;

    /**
     * @Serializer\SerializedName("OrderDir")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderDir;

    /**
     * @Serializer\SerializedName("FullResponse")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $fullResponse;

    /**
     * @Serializer\SerializedName("Applications")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\Application\All\Response\Version3\ApplicationType>")
     * @Serializer\XmlList(inline = true, entry = "Application")
     * @var ApplicationType[]
     */
    private $applications = [];

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @param string $count
     */
    public function setCount($count)
    {
        $this->count = $count;
    }

    /**
     * @param int $offset
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
    }

    /**
     * @param int $limit
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
    }

    /**
     * @param string $orderBy
     */
    public function setOrderBy($orderBy)
    {
        $this->orderBy = $orderBy;
    }

    /**
     * @param string $orderDir
     */
    public function setOrderDir($orderDir)
    {
        $this->orderDir = $orderDir;
    }

    /**
     * @param int $fullResponse
     */
    public function setFullResponse($fullResponse)
    {
        $this->fullResponse = $fullResponse;
    }

    /**
     * @param ApplicationType $applicationType
     */
    public function addApplication(ApplicationType $applicationType)
    {
        $this->applications[] = $applicationType;
    }
}
