<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 * @package Sso\WebserviceBundle\Services\Application\All\Response\Version3
 */
final class ApplicationType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Sso\WebserviceBundle\Services\Application\All\Response\Version3\AttributeType")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\Application\All\Response\Version3\AttributeType>")
     * @Serializer\XmlList(inline=true, entry="AttributeType")
     * @var AttributeType[]
     */
    private $attributeType = [];

    /**
     * @Serializer\SerializedName("Sso\WebserviceBundle\Services\Application\All\Response\Version3\AttributeType")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\Application\All\Response\Version3\ApplicationRoleType>")
     * @Serializer\XmlList(inline=true, entry="ApplicationRoleType")
     * @var ApplicationRoleType[]
     */
    private $applicationRoleType = [];

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @param AttributeType $attributeType
     */
    public function addAttributeType(AttributeType $attributeType)
    {
        $this->attributeType[] = $attributeType;
    }

    /**
     * @param ApplicationRoleType $applicationRoleType
     */
    public function addApplicationRoleType(ApplicationRoleType $applicationRoleType)
    {
        $this->applicationRoleType[] = $applicationRoleType;
    }
}
