<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All\ResponseData;

/**
 * Class ApplicationType
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\Application\All\ResponseData
 */
final class ApplicationType
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var AttributeType[]
     */
    private $attributeType = [];

    /**
     * @var ApplicationRoleType[]
     */
    private $applicationRoleType = [];

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @param AttributeType $attributeType
     */
    public function addAttributeType(AttributeType $attributeType)
    {
        $this->attributeType[] = $attributeType;
    }

    /**
     * @return AttributeType[]
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param ApplicationRoleType $applicationRoleType
     */
    public function addApplicationRoleType(ApplicationRoleType $applicationRoleType)
    {
        $this->applicationRoleType[] = $applicationRoleType;
    }

    /**
     * @return ApplicationRoleType[]
     */
    public function getApplicationRoleType()
    {
        return $this->applicationRoleType;
    }
}
