<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All\ResponseData;


/**
 * Class AttributeType
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\Application\All\ResponseData
 */
final class AttributeType
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string|null
     */
    private $displayType;

    /**
     * @var AttributeTypeOption[]|null
     */
    private $attributeOptions;

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return AttributeType
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDisplayType(): ?string
    {
        return $this->displayType;
    }

    /**
     * @param string|null $displayType
     */
    public function setDisplayType(?string $displayType): void
    {
        $this->displayType = $displayType;
    }

    /**
     * @return AttributeTypeOption[]|null
     */
    public function getAttributeOptions(): ?array
    {
        return $this->attributeOptions;
    }

    /**
     * @param AttributeTypeOption $option
     */
    public function addAttributeOption(AttributeTypeOption $option): void
    {
        $this->attributeOptions[] = $option;
    }
}
