<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request\Version2;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class AttributeType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request\Version2
 */
class AttributeType
{
    /**
     * @Assert\NotBlank()
     *
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Assert\NotBlank()
     * @Assert\Choice({"one", "many"})
     *
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $type;

    /**
     * @Assert\Choice({null, "input", "datepicker", "dropdown"})
     *
     * @Serializer\SerializedName("DisplayType")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $displayType;

    /**
     * @Assert\Valid()
     *
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request\Version2\AttributeOption>")
     * @Serializer\XmlList(inline=true,entry="AttributeOption")
     *
     * @var AttributeOption[]|null
     */
    private $attributeOptions;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string|null
     */
    public function getDisplayType(): ?string
    {
        return $this->displayType;
    }

    /**
     * @return AttributeOption[]|null
     */
    public function getAttributeOptions(): ?array
    {
        return $this->attributeOptions;
    }
}
