<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request\Version2;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request\Version2
 */
class Request
{
    /**
     * @Assert\NotNull()
     * @Assert\Valid()
     *
     * @Serializer\SerializedName("ApplicationAttribute")
     * @Serializer\Type("Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request\Version2\ApplicationAttribute")
     * @var ApplicationAttribute
     */
    private $applicationAttribute;

    /**
     * @return ApplicationAttribute
     */
    public function getApplicationAttribute(): ApplicationAttribute
    {
        return $this->applicationAttribute;
    }
}
