<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Response\Version2;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Add
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Response\Version2
 */
class Add
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Response\Version2\AttributeType")
     * @var AttributeType
     */
    private $attributeType;

    /**
     * @param string $status
     */
    public function setStatus(string $status): void
    {
        $this->status = $status;
    }

    /**
     * @param AttributeType $attributeType
     */
    public function setAttributeType(AttributeType $attributeType): void
    {
        $this->attributeType = $attributeType;
    }
}
