<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Response\Version2;

use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;
use Sso\WebserviceBundle\ErrorHandler\Response\ResponseInterface as ErrorsInterface;

use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Model\ResponseStatusTrait;

/**
 * Class Response
 *
 * @Serializer\XmlRoot(name="SsoResponse")
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Response\Version2
 */
class Response
{
    use ResponseStatusTrait;

    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     *
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("ScriptTimeSec")
     * @Serializer\Type("double")
     *
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("ApplicationAttribute")
     * @Serializer\Type("Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Response\Version2\ApplicationAttribute")
     *
     * @var ApplicationAttribute
     */
    private $applicationAttribute;

    /**
     * @Serializer\XmlList(inline = true)
     *
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->date = new \DateTime();
        $this->trackid = ApiException::getTrackId();
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
        $this->status = $this->statusCodeToStatus($code);
    }

    /**
     * @param \DateTime $date
     */
    public function setDate(\DateTime $date): void
    {
        $this->date = $date;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec(float $scriptTimeSec): void
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @param ApplicationAttribute $applicationAttribute
     */
    public function setApplicationAttribute(ApplicationAttribute $applicationAttribute): void
    {
        $this->applicationAttribute = $applicationAttribute;
    }

    /**
     * @param ErrorsInterface $errors
     */
    public function setErrors(ErrorsInterface $errors): void
    {
        $this->errors = $errors;
    }

    public function resetTrackid(): void
    {
        $this->trackid = null;
    }

    public function resetDate(): void
    {
        $this->date = null;
    }
}
