<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\ApplicationAttribute\Add\ResponseData;

/**
 * Class ApplicationAttributeData
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\ApplicationAttribute\Add\ResponseData
 */
class ApplicationAttributeData
{
    /**
     * @var string
     */
    private $applicationName;

    /**
     * @var string
     */
    private $attributeName;

    /**
     * @var string
     */
    private $attributeType;

    /**
     * @var string|null
     */
    private $attributeDisplayType;

    /**
     * @var array|null
     */
    private $attributeOptions;

    /**
     * @return string
     */
    public function getApplicationName(): string
    {
        return $this->applicationName;
    }

    /**
     * @param string $applicationName
     */
    public function setApplicationName(string $applicationName): void
    {
        $this->applicationName = $applicationName;
    }

    /**
     * @return string
     */
    public function getAttributeName(): string
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     */
    public function setAttributeName(string $attributeName): void
    {
        $this->attributeName = $attributeName;
    }

    /**
     * @return string
     */
    public function getAttributeType(): string
    {
        return $this->attributeType;
    }

    /**
     * @param string $attributeType
     */
    public function setAttributeType(string $attributeType): void
    {
        $this->attributeType = $attributeType;
    }

    /**
     * @return string|null
     */
    public function getAttributeDisplayType(): ?string
    {
        return $this->attributeDisplayType;
    }

    /**
     * @param string|null $attributeDisplayType
     */
    public function setAttributeDisplayType(?string $attributeDisplayType): void
    {
        $this->attributeDisplayType = $attributeDisplayType;
    }

    /**
     * @return array|null
     */
    public function getAttributeOptions(): ?array
    {
        return $this->attributeOptions;
    }

    /**
     * @param array|null $attributeOptions
     */
    public function setAttributeOptions(?array $attributeOptions): void
    {
        $this->attributeOptions = $attributeOptions;
    }
}
