<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\ApplicationAttribute\Show\Response\Version2;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\ApplicationAttribute\Show\Response\Version2
 */
class AttributeType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $type;

    /**
     * @Serializer\SerializedName("DisplayType")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $displayType;

    /**
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\ApplicationAttribute\Show\Response\Version2\AttributeOption>")
     * @Serializer\XmlList(inline=true,entry="AttributeOption")
     *
     * @var AttributeOption[]|null
     */
    private $attributeOptions;

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {
        $this->type = $type;
    }

    /**
     * @param string|null $displayType
     */
    public function setDisplayType(?string $displayType): void
    {
        $this->displayType = $displayType;
    }

    /**
     * @param AttributeOption[]|null $attributeOptions
     */
    public function setAttributeOptions(?array $attributeOptions): void
    {
        $this->attributeOptions = $attributeOptions;
    }
}
