<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("PasswordPolicyType")
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\PasswordPolicy\Show\Request\Version2
 */
final class PasswordPolicyType
{
    /**
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      exactMessage = "policyId should have exactly {{ limit }} characters."
     * )
     * @Serializer\SerializedName("PolicyId")
     * @Serializer\Type("string")
     * @var string
     */
    private $policyId;

    /**
     * @return string
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }
}
