<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class PasswordPolicyValidationsType
 * @package Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3
 */
final class PasswordPolicyValidationsType
{
    /**
     * @Serializer\SerializedName("OrderId")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderId;

    /**
     * @Serializer\SerializedName("RegEx")
     * @Serializer\Type("string")
     * @var string
     */
    private $regEx;

    /**
     * @Serializer\SerializedName("ErrorMessages")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\TranslationType>")
     * @Serializer\XmlList(inline = false, entry = "Translation")
     * @var TranslationType[]|ArrayCollection
     */
    private $errorMessages = [];

    /**
     * @Serializer\SerializedName("HintMessages")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\TranslationType>")
     * @Serializer\XmlList(inline = false, entry = "Translation")
     * @var TranslationType[]|ArrayCollection
     */
    private $hintMessages = [];

    /**
     * PasswordPolicyType constructor.
     */
    public function __construct()
    {
        $this->errorMessages = new ArrayCollection();
        $this->hintMessages = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param string $orderId
     * @return PasswordPolicyValidationsType
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string $regEx
     * @return PasswordPolicyValidationsType
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @return TranslationType[]
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param TranslationType $errorMessages
     * @return PasswordPolicyValidationsType
     */
    public function addErrorMessages(TranslationType $errorMessages)
    {
        if(!$this->errorMessages->contains($errorMessages)){
            $this->errorMessages->add($errorMessages);
        }
        return $this;
    }

    /**
     * @return TranslationType[]
     */
    public function getHintMessages()
    {
        return $this->hintMessages;
    }

    /**
     * @param TranslationType $hintMessages
     * @return PasswordPolicyValidationsType
     */
    public function addHintMessages(TranslationType $hintMessages)
    {
        if(!$this->hintMessages->contains($hintMessages)){
            $this->hintMessages->add($hintMessages);
        }
        return $this;
    }
}
