<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Add\Response\Version4;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\WebserviceBundle\Services\User\Show\Response\Version4
 */
final class UserType
{
    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("Firstname")
     * @Serializer\Type("string")
     * @var string
     */
    private $firstname;

    /**
     * @Serializer\SerializedName("Lastname")
     * @Serializer\Type("string")
     * @var string
     */
    private $lastname;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getActiveAsInteger")
     * @var boolean
     */
    private $active;

    /**
     * @Serializer\SerializedName("ActivateToken")
     * @Serializer\Type("string")
     * @var string
     */
    private $activateToken;

    /**
     * @Serializer\SerializedName("ActivateTokenExpire")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $activateTokenExpire = null;

    /**
     * @Serializer\SerializedName("Deleted")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getDeletedAsInteger")
     * @var boolean
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("CreatedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("LastLoginAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $lastLoginAt = null;

    /**
     * @Serializer\SerializedName("UpdatedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @Serializer\SerializedName("AuthId")
     * @Serializer\Type("string")
     * @var string
     */
    private $authId;

    /**
     * @Serializer\SerializedName("LdapSearchAttributes")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @Serializer\SerializedName("LdapSearchValue")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @Serializer\SerializedName("MfaEnabled")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getMfaEnabledAsInteger")
     * @var boolean
     */
    private $mfaEnabled;

    /**
     * @Serializer\SerializedName("PasswordPolicy")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $passwordPolicy;

    /**
     * @Serializer\SerializedName("LastPasswordChange")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $lastPasswordChange;

    /**
     * @Serializer\SerializedName("PasswordExpired")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $passwordExpired;

    /**
     * @Serializer\SerializedName("PasswordEncryptType")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $passwordEncryptType;

    /**
     * @Serializer\SerializedName("UserGroups")
     * @Serializer\Type("array<string>")
     * @Serializer\XmlList(entry="UserGroup")
     *
     * @var array|string[]|null
     */
    private $userGroups;

    /**
     * @param array $userAttributes
     * @return UserType
     */
    public function setFromArray(array $userAttributes)
    {
        foreach ($userAttributes as $name => $value) {
            $method = 'set' . ucfirst($name);
            if (!method_exists($this, $method)) {
                throw new \BadMethodCallException(sprintf(
                    'Unable to create user response model %s! Userattribute %s does not exist.',
                    self::class,
                    $name
                ));
            }
            $this->$method($value);
        }

        return $this;
    }

    /**
     * @param string $guid
     * @return void
     */
    public function setGuid($guid): void
    {
        $this->guid = $guid;
    }

    /**
     * @param string $username
     * @return void
     */
    public function setUsername($username): void
    {
        $this->username = $username;
    }

    /**
     * @param string $email
     * @return void
     */
    public function setEmail($email): void
    {
        $this->email = $email;
    }

    /**
     * @param string $firstname
     * @return void
     */
    public function setFirstname($firstname): void
    {
        $this->firstname = $firstname;
    }

    /**
     * @param string $lastname
     * @return void
     */
    public function setLastname($lastname): void
    {
        $this->lastname = $lastname;
    }

    /**
     * @param boolean $active
     * @return void
     */
    public function setActive($active): void
    {
        $this->active = $active;
    }

    /**
     * @return integer
     */
    public function getActiveAsInteger(): int
    {
        return $this->active ? 1 : 0;
    }

    /**
     * @param mixed $activateToken
     * @return void
     */
    public function setActivateToken($activateToken): void
    {
        $this->activateToken = $activateToken;
    }

    /**
     * @param \DateTime $activateTokenExpire
     * @return void
     */
    public function setActivateTokenExpire($activateTokenExpire): void
    {
        $this->activateTokenExpire = $activateTokenExpire;
    }

    /**
     * @param boolean $deleted
     * @return void
     */
    public function setDeleted($deleted): void
    {
        $this->deleted = $deleted;
    }

    /**
     * @return integer
     */
    public function getDeletedAsInteger(): int
    {
        return $this->deleted ? 1 : 0;
    }

    /**
     * @param \DateTime $createdAt
     * @return void
     */
    public function setCreatedAt($createdAt): void
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return void
     */
    public function setLastLoginAt($lastLoginAt): void
    {
        $this->lastLoginAt = $lastLoginAt;
    }

    /**
     * @param \DateTime $updatedAt
     * @return void
     */
    public function setUpdatedAt($updatedAt): void
    {
        $this->updatedAt = $updatedAt;
    }

    /**
     * @param string $authId
     * @return void
     */
    public function setAuthId($authId): void
    {
        $this->authId = $authId;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return void
     */
    public function setLdapSearchAttributes($ldapSearchAttributes): void
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchValue
     * @return void
     */
    public function setLdapSearchValue($ldapSearchValue): void
    {
        $this->ldapSearchValue = $ldapSearchValue;
    }

    /**
     * @param boolean $mfaEnabled
     * @return void
     */
    public function setMfaEnabled($mfaEnabled): void
    {
        $this->mfaEnabled = $mfaEnabled;
    }

    /**
     * @return integer
     */
    public function getMfaEnabledAsInteger(): int
    {
        return $this->mfaEnabled ? 1 : 0;
    }

    /**
     * @param string $passwordPolicy
     * @return void
     */
    public function setPasswordPolicy($passwordPolicy): void
    {
        $this->passwordPolicy = $passwordPolicy;
    }

    /**
     * @param \DateTime $lastPasswordChange
     * @return void
     */
    public function setLastPasswordChange($lastPasswordChange): void
    {
        $this->lastPasswordChange = $lastPasswordChange instanceof \DateTime ? clone $lastPasswordChange : null;
    }

    /**
     * @param int $passwordExpired
     * @return void
     */
    public function setPasswordExpired($passwordExpired): void
    {
        $this->passwordExpired = $passwordExpired;
    }

    /**
     * @param string $passwordEncryptType
     */
    public function setPasswordEncryptType(string $passwordEncryptType): void
    {
        $this->passwordEncryptType = $passwordEncryptType;
    }

    /**
     * @param array|string[]|null $userGroups
     */
    public function setUserGroups($userGroups): void
    {
        $this->userGroups = $userGroups;
    }
}
