<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version3;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\User\ChangePassword\RequestData\Factory as RequestDataFactory;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class Factory
 * @package Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version3
 */
class Factory
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * @var RequestDataFactory;
     */
    private $requestDataFactory;

    /**
     * @var ValidatorInterface
     */
    private $validator;
    /**
     * @var \Sso\WebserviceBundle\ErrorHandler\Manager
     */
    private $errorHandler;

    /**
     * Factory constructor.
     *
     * @param ApiManagerInterface $apiM
     * @param RequestDataFactory $requestDataFactory
     */
    public function __construct(ApiManagerInterface $apiM, RequestDataFactory $requestDataFactory)
    {
        $this->apiM = $apiM;
        $this->requestDataFactory = $requestDataFactory;
        $this->errorHandler = $this->apiM->errorHandler();
        $this->validator = $this->apiM->validator();
    }

    /**
     * @return RequestParser
     */
    public function requestParser()
    {
        return new RequestParser($this->apiM->serializer(), $this->requestDataFactory, $this->errorHandler, $this->validator, $this->apiM->mapper());
    }
}
