<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version3;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ValueUserType
 *
 * @Serializer\XmlRoot("PasswordType")
 *
 * @package Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version3
 */
class ValuePasswordType
{
    /**
     * @Serializer\Exclude
     * @var string
     */
    protected $identifier;

    /**
     * @Serializer\SerializedName("Password")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $currentPassword;

    /**
     * @Assert\NotBlank()
     * @Serializer\SerializedName("NewPassword")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $newPassword;

    /**
     * @return string
     */
    public function getCurrentPassword()
    {
        return $this->currentPassword;
    }

    /**
     * @param string $currentPassword
     * @return ValuePasswordType
     */
    public function setCurrentPassword($currentPassword)
    {
        $this->currentPassword = $currentPassword;
        return $this;
    }

    /**
     * @return string
     */
    public function getNewPassword()
    {
        return $this->newPassword;
    }

    /**
     * @param string $newPassword
     * @return ValuePasswordType
     */
    public function setNewPassword($newPassword)
    {
        $this->newPassword = $newPassword;
        return $this;
    }

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $identifier
     * @return ValuePasswordType
     */
    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
        return $this;
    }
}
