<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ResetPassword\Request\Version2;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class User
 *
 * @Serializer\XmlRoot("User")
 *
 * @package Sso\WebserviceBundle\Services\User\ResetPassword\Request\Version2
 */
class User
{
    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("ResetPassword")
     * @Serializer\Type("Sso\WebserviceBundle\Services\User\ResetPassword\Request\Version2\ResetPassword")
     * @var ResetPassword
     */
    protected $resetPassword;

    /**
     * @return ResetPassword
     */
    public function getResetPassword()
    {
        return $this->resetPassword;
    }
}
