<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ResetPassword\Response;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\ApiVersionInflectorInterface;

/**
 * Class Factory
 * @package Sso\WebserviceBundle\Services\User\ResetPassword\Response
 */
class Factory
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * @var ApiVersionInflectorInterface
     */
    private $apiVersionInflector;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * Factory constructor.
     * @param ApiManagerInterface $apiM
     * @param ApiVersionInflectorInterface $apiVersionInflector
     */
    public function __construct(ApiManagerInterface $apiM, ApiVersionInflectorInterface $apiVersionInflector)
    {
        $this->apiM = $apiM;
        $this->apiVersionInflector = $apiVersionInflector;
    }

    /**
     * @return ResponseFactoryInterface
     */
    public function getFactory()
    {
        $className = $this->apiVersionInflector->inflect(__NAMESPACE__, 'Factory');

        return isset($this->factory[__METHOD__]) ? $this->factory[__METHOD__] : ($this->factory[__METHOD__] = new $className($this->apiM));
    }
}
