<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Show\Response\Version5;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsObjectInterface;

/**
 * Class Show
 * @package Sso\WebserviceBundle\Services\User\Show\Response\Version5
 */
final class Show
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\User\Show\Response\Version5\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @param string $status
     * @return Show
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param UserType $userType
     * @return Show
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;
        return $this;
    }
}
