<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\Request;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\ApiVersionInflectorInterface;
use Sso\WebserviceBundle\Services\User\Update\RequestData\Factory as RequestDataFactory;

/**
 * Class Factory
 *
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 * @package     Sso\WebserviceBundle\Services\User\Update\Request
 */
final class Factory
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * @var ApiVersionInflectorInterface
     */
    private $apiVersionInflector;

    /**
     * @var RequestDataFactory;
     */
    private $requestDataFactory;

    /**
     * @var array
     */
    private $factory = [];

    /**
     * Factory constructor.
     * @param ApiManagerInterface $apiM
     * @param ApiVersionInflectorInterface $apiVersionInflector
     * @param RequestDataFactory $requestDataFactory
     */
    public function __construct(
        ApiManagerInterface $apiM,
        ApiVersionInflectorInterface $apiVersionInflector,
        RequestDataFactory $requestDataFactory
    ) {
        $this->apiM = $apiM;
        $this->apiVersionInflector = $apiVersionInflector;
        $this->requestDataFactory = $requestDataFactory;
    }

    /**
     * @return RequestFactoryInterface
     */
    public function factory()
    {
        $className = $this->apiVersionInflector->inflect(__NAMESPACE__, 'Factory');

        return isset($this->factory[__METHOD__]) ? $this->factory[__METHOD__] : ($this->factory[__METHOD__] = new $className($this->apiM,
            $this->requestDataFactory));
    }
}
