<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\Request\Version5;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ValueUserGroups
 *
 * This class is a workaround to make it possible not to update user-groups
 * if they are not part of the xml-request
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\User\Update\Request\Version5
 */
class ValueUserGroups
{
    /**
     * @Assert\Type(type="array")
     * @Serializer\Type("array<string>")
     * @Serializer\XmlList(inline=true, entry="UserGroup")
     *
     * @var array|string[]|null
     */
    private $userGroups;

    /**
     * @return array|string[]|null
     */
    public function getUserGroups()
    {
        return $this->userGroups;
    }
}
